% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_stream.R
\name{scale_length_continuous}
\alias{scale_length_continuous}
\title{Create a Continuous Scale for Vector Length}
\usage{
scale_length_continuous(max_range = 0.5, ...)
}
\arguments{
\item{max_range}{The maximum value to which the input is rescaled. Numeric
scalar specifying the upper bound of the output range. Should be between 0
and 1.}

\item{...}{Other arguments passed to \code{continuous_scale()}.}
}
\value{
If \code{max_range} is less than or equal to 0.5 (the default), a
continuous scale object (typically of class \code{"ScaleContinuous"})
mapping the \code{length} aesthetic is returned. If \code{max_range} is
greater than 0.5, a list is returned with two components:
\itemize{
\item the continuous scale object, and
\item a theme modification (a \code{theme} object) that adjusts the legend key width based
on the value of \code{max_range}.
}
}
\description{
\code{\link[=scale_length_continuous]{scale_length_continuous()}} provides a continuous scale for controlling the
length aesthetic in a ggplot. This is particularly useful when working with
vector plots where vector lengths are mapped to a continuous scale.
}
