% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_vector_field.R
\name{geom_vector_field}
\alias{geom_vector_field}
\alias{stat_vector_field}
\alias{geom_vector_field2}
\alias{stat_vector_field2}
\title{Vector Field Layers for ggplot2}
\usage{
geom_vector_field(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  args = list(),
  center = TRUE,
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = unit(0.02, "npc"), type = "closed")
)

stat_vector_field(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = FALSE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  args = list(),
  center = TRUE,
  normalize = TRUE,
  tail_point = FALSE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = grid::arrow(angle = 30, length = unit(0.02, "npc"), type = "closed")
)

geom_vector_field2(
  mapping = NULL,
  data = NULL,
  stat = StatStreamField,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = FALSE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  args = list(),
  center = FALSE,
  tail_point = TRUE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL
)

stat_vector_field2(
  mapping = NULL,
  data = NULL,
  geom = GeomStream,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = FALSE,
  fun,
  xlim = NULL,
  ylim = NULL,
  n = 11,
  args = list(),
  center = FALSE,
  tail_point = TRUE,
  eval_point = FALSE,
  grid = NULL,
  lineend = "butt",
  linejoin = "round",
  linemitre = 10,
  arrow = NULL
)
}
\arguments{
\item{mapping}{A set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}.
Additional aesthetics such as \code{color}, \code{size}, \code{linetype}, and \code{alpha} can
be defined. In
\strong{geom_vector_field}, the default mapping includes \code{color = after_stat(norm)},
whereas in \strong{geom_vector_field2} the default mapping includes \code{length = after_stat(norm)}.}

\item{data}{A data frame containing the input data.}

\item{stat}{The statistical transformation to use on the data for this layer.
Defaults to \link{StatStreamField}.}

\item{position}{Position adjustment, either as a string or the result of a
call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{grid::layer()}.}

\item{na.rm}{Logical. If \code{FALSE} (the default), missing values are removed
with a warning.}

\item{show.legend}{Logical. Should this layer be included in the legends?}

\item{inherit.aes}{Logical. If \code{FALSE}, overrides the default aesthetics
rather than combining with them.}

\item{fun}{A function that defines the vector field. It should take a numeric
vector of length 2 (representing \eqn{(x, y)}) and return a numeric vector
of length 2 (representing \eqn{(dx, dy)}). \strong{(Required)}}

\item{xlim}{Numeric vector of length two. Specifies the limits of the x-axis
domain. Defaults to \code{c(-1, 1)}.}

\item{ylim}{Numeric vector of length two. Specifies the limits of the y-axis
domain. Defaults to \code{c(-1, 1)}.}

\item{n}{Integer. Grid resolution specifying the number of seed points along
each axis. Higher values produce a denser vector field. Defaults to \code{11}.}

\item{args}{List of additional arguments passed on to the function defined by
\code{fun}.}

\item{center}{Logical. If \code{TRUE}, centers the seed points or the vectors so
that the original (x, y) becomes the midpoint. Defaults differ between the
variants.}

\item{normalize}{Logical. If \code{TRUE}, stream lengths are normalized based on
grid spacing. If \code{FALSE}, a default arc length is used. (Default is \code{TRUE};
if \code{TRUE}, it is converted internally to \code{"vector"}.)}

\item{tail_point}{Logical. If \code{TRUE}, a point is drawn at the tail of each
streamline.}

\item{eval_point}{Logical. If \code{TRUE}, a point is drawn at the evaluation
point, corresponding to the original (untransformed) seed point before any
centering or normalization is applied.}

\item{grid}{A data frame containing precomputed grid points for seed
placement. If \code{NULL} (default), a regular Cartesian grid is generated based
on \code{xlim}, \code{ylim}, and \code{n}.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{arrow}{A \code{grid::arrow()} specification to add arrowheads to the
streamlines. In \strong{geom_vector_field}, the default is a closed arrow with a
30° angle and length \code{0.02} npc; in \strong{geom_vector_field2} the default is
\code{NULL}.}

\item{geom}{The geometric object used to render the streamline (only used in
\code{stat_stream()}; defaults to \link{GeomStream}).}
}
\value{
A ggplot2 layer that computes and plots a vector field using
streamlines.

\describe{
\item{norm}{Calculated as the Euclidean distance between the starting point
(\code{x}, \code{y}) and the computed endpoint. Used to normalize the
vector.}
}
}
\description{
These functions provide convenient ggplot2 layers for drawing vector fields
using streamlines.
}
\details{
A user-defined function (\code{fun}) specifies the behavior of the vector field by
taking a numeric vector of length 2 (representing \eqn{(x, y)}) and returning
a numeric vector of length 2 (representing \eqn{(dx, dy)}). The underlying
\link{StatStreamField} computes the streamlines based on the vector field
function, and \link{GeomStream} renders them.

Two variants are provided:
\itemize{
\item \strong{geom_vector_field()} uses a default mapping that sets \code{color = after_stat(norm)}.
\item \strong{geom_vector_field2()} uses a default mapping that sets \code{length = after_stat(norm)}
(with \code{color} unmapped by default).
}
}
\section{Aesthetics}{
 \code{geom_vector_field()} and \code{geom_vector_field2()}
understand the following aesthetics (required aesthetics are in \strong{bold}):
\itemize{
\item \strong{\code{x}}: The x-coordinate of the vector's starting point.
\item \strong{\code{y}}: The y-coordinate of the vector's starting point.
\item \strong{\code{fx}}: The horizontal component of the vector displacement.
\item \strong{\code{fy}}: The vertical component of the vector displacement.
\item \code{color}: The color of the vector lines (default mapping in \strong{geom_vector_field}).
\item \code{length}: The computed vector norm (default mapping in \strong{geom_vector_field2}).
\item \code{linetype}: The type of the vector line (e.g., solid, dashed).
\item \code{linewidth}: The thickness of the vector line.
\item \code{alpha}: The transparency of the vector.
}
}

\examples{

f <- function(u) c(-u[2], u[1])
ggplot() + geom_vector_field(fun = f, xlim = c(-1,1), ylim = c(-1,1))
\donttest{
# xlim and ylim default to (-1,1), so for ease of illustration we remove them

ggplot() + geom_vector_field(fun = f)
ggplot() + geom_vector_field(fun = f, grid = "hex")

ggplot() + geom_vector_field2(fun = f)
ggplot() + geom_vector_field2(fun = f, grid = "hex")

f <- efield_maker()
ggplot() + geom_vector_field(fun = f, xlim = c(-2,2), ylim = c(-2,2))
ggplot() + geom_vector_field2(fun = f, xlim = c(-2,2), ylim = c(-2,2))
}

}
\seealso{
\code{\link[=geom_stream_field]{geom_stream_field()}}
}
