% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.metaMDS.R
\name{fortify.metaMDS}
\alias{fortify.metaMDS}
\alias{tidy.metaMDS}
\title{Fortify a \code{"mataMDS"} object.}
\usage{
\method{fortify}{metaMDS}(model, data, axes = 1:2, layers = c("sites", "species"), ...)

\method{tidy}{metaMDS}(x, data, layers = c("sites", "species"), ...)
}
\arguments{
\item{model, x}{an object of class \code{"metaMDS"}, the result of a call
to \code{\link[vegan:metaMDS]{vegan::metaMDS()}}.}

\item{data}{currently ignored.}

\item{axes}{numeric; which axes to extract scores for.}

\item{layers}{character; the scores to extract in the fortified object.
Passed to \code{display} in the respective \code{\link[vegan:scores]{vegan::scores()}} method.}

\item{...}{additional arguments passed to
\code{\link[vegan:metaMDS]{vegan::scores.metaMDS()}}. Note you can't use \code{display}.}
}
\value{
A data frame in long format containing the ordination scores.
The first two components are the axis scores.
}
\description{
Fortifies an object of class \code{"metaMDS"} to produce a
data frame of the selected axis scores in long format, suitable for
plotting with \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\details{
TODO
}
\examples{

library("vegan")

data(dune)

ord <- metaMDS(dune)
head(fortify(ord))
}
\author{
Gavin L. Simpson
}
