% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.cca.R
\name{autoplot.cca}
\alias{autoplot.cca}
\title{ggplot-based plot for objects of class \code{"cca"}}
\usage{
\method{autoplot}{cca}(
  object,
  axes = c(1, 2),
  geom = c("point", "text"),
  layers = c("species", "sites", "biplot", "centroids"),
  legend.position = "right",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ylab = NULL,
  xlab = NULL,
  arrow.col = "navy",
  ...
)
}
\arguments{
\item{object}{an object of class \code{"cca"}, the result of a call to
\code{\link[vegan:cca]{vegan::cca()}} or \code{\link[vegan:dbrda]{vegan::capscale()}}.}

\item{axes}{numeric; which axes to plot, given as a vector of length 2.}

\item{geom}{character; which geom to use for the species (variables) and
sites (samples) layers. A vector of length 2; if a vector of length 1,
\code{geom} is extended to the required length.}

\item{layers}{character; which scores to plot as layers}

\item{legend.position}{character or two-element numeric vector; where to
position the legend. See \code{\link[ggplot2:theme]{ggplot2::theme()}} for details. Use \code{"none"}
to not draw the legend.}

\item{title}{character; subtitle for the plot.}

\item{subtitle}{character; subtitle for the plot.}

\item{caption}{character; caption for the plot.}

\item{ylab}{character; label for the y-axis.}

\item{xlab}{character; label for the x-axis.}

\item{arrow.col}{colour specification for biplot arrows and their labels.}

\item{...}{Additional arguments passed to the \code{\link[=fortify]{fortify()}} method.}
}
\value{
Returns a ggplot object.
}
\description{
Produces a multi-layer ggplot object representing the output of objects
produced by \code{\link[vegan:cca]{vegan::cca()}} or \code{\link[vegan:dbrda]{vegan::capscale()}}.
}
\details{
TODO
}
\examples{

library("vegan")
data(dune)
data(dune.env)

sol <- cca(dune ~ A1 + Management, data = dune.env)
autoplot(sol)
}
\author{
Gavin L. Simpson
}
