% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_variant_spectrum}
\alias{plot_variant_spectrum}
\title{Mutational spectrum (SBS) bar chart}
\usage{
plot_variant_spectrum(
  variants,
  sample = NULL,
  context = FALSE,
  genome = NULL,
  facet_by_sample = FALSE,
  palette = NULL,
  normalize = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{variants}{A \code{gvf} object or compatible \code{data.frame} containing SNVs.
Indels are automatically excluded.}

\item{sample}{Character. Sample name to filter on. \code{NULL} uses all variants
pooled (or facets by sample if \code{facet_by_sample = TRUE}).}

\item{context}{Logical. If \code{TRUE}, shows 96-trinucleotide context bars
(requires a \code{context} column or a reference genome via \code{genome}).
Default \code{FALSE}.}

\item{genome}{A \code{BSgenome} object or genome abbreviation string (e.g.
\code{"hg38"}) used to extract trinucleotide context when \code{context = TRUE}
and no \code{context} column is present. Requires the \code{BSgenome} and
\code{Biostrings} packages.}

\item{facet_by_sample}{Logical. If \code{TRUE}, facets the plot by sample.
Default \code{FALSE}.}

\item{palette}{Named character vector with names matching substitution
classes (\code{"C>A"}, \code{"C>G"}, etc.). \code{NULL} uses COSMIC-style colours.}

\item{normalize}{Logical. If \code{TRUE} (default), shows relative proportions.
If \code{FALSE}, shows raw counts.}

\item{interactive}{Logical. Returns a \code{plotly} object if \code{TRUE}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plots the single-base substitution (SBS) spectrum — the relative frequency
of each of the 6 substitution classes (C>A, C>G, C>T, T>A, T>C, T>G) —
optionally broken down by trinucleotide context.
}
\examples{
vcf_file <- system.file("extdata", "example.vcf", package = "ggvariant")
variants <- read_vcf(vcf_file)

# Basic 6-class SBS spectrum
plot_variant_spectrum(variants)

# Faceted by sample
plot_variant_spectrum(variants, facet_by_sample = TRUE)

}
