% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_consequence_summary}
\alias{plot_consequence_summary}
\title{Consequence summary bar chart}
\usage{
plot_consequence_summary(
  variants,
  samples = NULL,
  group_by = c("consequence", "gene"),
  top_n = 10L,
  position = c("stack", "fill", "dodge"),
  palette = NULL,
  flip = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{variants}{A \code{gvf} object or compatible \code{data.frame}.}

\item{samples}{Character vector of sample names to include. \code{NULL} (default)
uses all samples. Ignored if there is no \code{sample} column.}

\item{group_by}{\code{"consequence"} (default) stacks bars by consequence per
sample; \code{"gene"} stacks by gene per consequence.}

\item{top_n}{Integer. For \code{group_by = "gene"}, show only the top N genes by
total variant count. Default \code{10}.}

\item{position}{\code{"stack"} (default) or \code{"fill"} (proportional) or
\code{"dodge"}.}

\item{palette}{Named character vector of colours. \code{NULL} uses built-in.}

\item{flip}{Logical. If \code{TRUE}, flips coordinates for horizontal bars.
Default \code{FALSE}.}

\item{interactive}{Logical. Returns a \code{plotly} object if \code{TRUE}.}
}
\value{
A \code{ggplot} object.
}
\description{
Summarises variant consequences (e.g. missense, frameshift, synonymous)
across one or more samples, producing a stacked or grouped bar chart.
}
\examples{
vcf_file <- system.file("extdata", "example.vcf", package = "ggvariant")
variants <- read_vcf(vcf_file)

# Consequence counts per sample
plot_consequence_summary(variants)

# Proportional bars
plot_consequence_summary(variants, position = "fill")

# Top 10 genes coloured by consequence
plot_consequence_summary(variants, group_by = "gene", top_n = 10)

}
