% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vcf.R
\name{coerce_variants}
\alias{coerce_variants}
\title{Coerce a plain data frame to a \code{gvf} object}
\usage{
coerce_variants(
  x,
  chrom = "chrom",
  pos = "pos",
  ref = "ref",
  alt = "alt",
  consequence = "consequence",
  gene = "gene",
  sample = "sample"
)
}
\arguments{
\item{x}{A \code{data.frame} or \code{tibble}.}

\item{chrom}{Column name containing chromosome (default \code{"chrom"}).}

\item{pos}{Column name containing position (default \code{"pos"}).}

\item{ref}{Column name containing reference allele (default \code{"ref"}).}

\item{alt}{Column name containing alternate allele (default \code{"alt"}).}

\item{consequence}{Column name containing variant consequence annotation,
e.g. \code{"Missense_Mutation"}. If \code{NULL}, consequence is inferred from
REF/ALT lengths.}

\item{gene}{Column name containing gene symbol (default \code{"gene"}).}

\item{sample}{Column name containing sample identifier (default \code{"sample"}).}
}
\value{
A \code{gvf} object.
}
\description{
If you already have variant data in a \code{data.frame} (e.g. exported from
Excel, a database, or another tool), use this function to prepare it for
use with \code{ggvariant} plotting functions.
}
\examples{
df <- data.frame(
  chromosome = c("chr1", "chr1", "chr7"),
  position   = c(100200, 100350, 55249071),
  ref_allele = c("A", "G", "C"),
  alt_allele = c("T", "A", "T"),
  variant_class = c("missense_variant", "synonymous_variant", "missense_variant"),
  hugo_symbol = c("GENE1", "GENE1", "EGFR"),
  tumor_sample = c("S1", "S2", "S2")
)

variants <- coerce_variants(df,
  chrom       = "chromosome",
  pos         = "position",
  ref         = "ref_allele",
  alt         = "alt_allele",
  consequence = "variant_class",
  gene        = "hugo_symbol",
  sample      = "tumor_sample"
)

}
