% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_training.R
\name{lr_scheduler_step}
\alias{lr_scheduler_step}
\title{Step-decay learning rate scheduler}
\usage{
lr_scheduler_step(optimizer, step_size, gamma = 0.1)
}
\arguments{
\item{optimizer}{An \code{ag_optimizer_adam} or \code{ag_optimizer_sgd}
environment.}

\item{step_size}{Decay every this many steps (epochs).}

\item{gamma}{Multiplicative decay factor (default 0.1).}
}
\value{
An \code{lr_scheduler_step} environment
}
\description{
Multiplies the optimizer learning rate by \code{gamma} every
\code{step_size} calls to \code{$step()}.
}
\examples{
\donttest{
w   <- ag_param(matrix(runif(4), 2, 2))
opt <- optimizer_adam(list(w = w), lr = 0.1)
sch <- lr_scheduler_step(opt, step_size = 10L, gamma = 0.5)
for (epoch in 1:30) sch$step()
opt$lr  # 0.1 * 0.5^3 = 0.0125
}
}
