% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_model.R
\name{ggml_load_model}
\alias{ggml_load_model}
\title{Load a Full Model (Architecture + Weights)}
\usage{
ggml_load_model(path, backend = "auto")
}
\arguments{
\item{path}{File path to an RDS file written by \code{ggml_save_model()}.}

\item{backend}{Backend selection: \code{"auto"}, \code{"cpu"}, or
\code{"vulkan"}.}
}
\value{
A compiled model object.
}
\description{
Restores a model previously saved with \code{ggml_save_model()}.  The
returned model is compiled and ready for \code{ggml_predict()} /
\code{ggml_evaluate()}.  Call \code{ggml_fit()} again to continue training.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_dense(16L, activation = "relu", input_shape = 4L) |>
  ggml_layer_dense(2L,  activation = "softmax")
model <- ggml_compile(model, optimizer = "adam",
                       loss = "categorical_crossentropy")
x <- matrix(runif(64 * 4), 64, 4)
y <- matrix(c(rep(c(1,0), 32), rep(c(0,1), 32)), 64, 2)
model <- ggml_fit(model, x, y, epochs = 1L, batch_size = 32L, verbose = 0L)
tmp <- tempfile(fileext = ".rds")
ggml_save_model(model, tmp)
model2 <- ggml_load_model(tmp)
}
}
