% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_lstm}
\alias{ggml_layer_lstm}
\title{Add an LSTM Layer}
\usage{
ggml_layer_lstm(
  model,
  units,
  return_sequences = FALSE,
  activation = "tanh",
  recurrent_activation = "sigmoid",
  input_shape = NULL,
  name = NULL,
  trainable = TRUE
)
}
\arguments{
\item{model}{A \code{ggml_sequential_model} or \code{ggml_tensor_node}.}

\item{units}{Integer, number of hidden units.}

\item{return_sequences}{Logical; if \code{TRUE} return all hidden states,
otherwise return only the last hidden state.}

\item{activation}{Activation for the cell gate (default \code{"tanh"}).}

\item{recurrent_activation}{Activation for the recurrent step (default
\code{"sigmoid"}).}

\item{input_shape}{Input shape \code{c(seq_len, input_size)} -- required for the first layer only.}

\item{name}{Optional layer name.}

\item{trainable}{Logical.}
}
\value{
Updated model or a new \code{ggml_tensor_node}.
}
\description{
Long Short-Term Memory recurrent layer.  Implemented as an unrolled
computation graph (BPTT) so that ggml's automatic differentiation works
without any C extensions.
}
\section{Weight layout}{

\itemize{
  \item \code{W_gates} \code{[input_size, 4*units]} — input kernel for all
    four gates (i, f, g, o) concatenated.
  \item \code{U_gates} \code{[units, 4*units]} — recurrent kernel.
  \item \code{b_gates} \code{[4*units]} — bias.
}
}

\section{Input / output shapes}{

Input: \code{[seq_len, input_size]} per sample (R row-major), or a 3-D
array \code{[N, seq_len, input_size]}.  In the Functional API the input
node shape should be \code{c(seq_len, input_size)}.

Output (Sequential): \code{[units]} per sample when
\code{return_sequences = FALSE} (default), or \code{c(seq_len, units)}
when \code{return_sequences = TRUE}.
}

\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_lstm(64L, input_shape = c(10L, 32L)) |>
  ggml_layer_dense(10L, activation = "softmax")
}
}
