% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_global_average_pooling_2d}
\alias{ggml_layer_global_average_pooling_2d}
\title{Global Average Pooling for 2D Feature Maps}
\usage{
ggml_layer_global_average_pooling_2d(model, name = NULL, trainable = TRUE)
}
\arguments{
\item{model}{A \code{ggml_sequential_model} or \code{ggml_tensor_node}.}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; reserved for API consistency (no weights).}
}
\value{
Updated model or a new \code{ggml_tensor_node}.
}
\description{
Reduces a \code{[H, W, C]} feature map to \code{[C]} by averaging all
spatial positions per channel.  Equivalent to Keras
\code{GlobalAveragePooling2D()}.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1)) |>
  ggml_layer_global_average_pooling_2d() |>
  ggml_layer_dense(10, activation = "softmax")
}
}
