% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_layers.R
\name{ggml_layer_flatten}
\alias{ggml_layer_flatten}
\title{Add Flatten Layer}
\usage{
ggml_layer_flatten(model, name = NULL, trainable = TRUE)
}
\arguments{
\item{model}{A ggml_sequential_model object}

\item{name}{Optional character name for the layer.}

\item{trainable}{Logical; reserved for API consistency (no weights).}
}
\value{
The model object with the flatten layer appended (invisibly).
}
\description{
Flattens the spatial dimensions into a single vector per sample.
}
\examples{
\donttest{
model <- ggml_model_sequential() |>
  ggml_layer_conv_2d(32, c(3,3), activation = "relu",
                     input_shape = c(28, 28, 1)) |>
  ggml_layer_flatten()
}
}
