% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_input}
\alias{ggml_input}
\title{Declare a Functional API Input Tensor}
\usage{
ggml_input(shape, name = NULL, dtype = "float32")
}
\arguments{
\item{shape}{Integer vector describing the shape of a single sample.
For flat feature vectors use a scalar, e.g. \code{shape = 64L}.
For 2-D inputs (sequences) use \code{c(length, channels)}.
For 3-D inputs (images) use \code{c(H, W, C)}.}

\item{name}{Optional character name for the input tensor.}

\item{dtype}{Data type of the input: \code{"float32"} (default) or
\code{"int32"} (for embedding/token-index inputs).}
}
\value{
A \code{ggml_tensor_node} object.
}
\description{
Creates a symbolic input node for the Functional API.  The node records
only the \emph{shape} of one sample (without batch dimension); actual
memory is allocated when \code{ggml_compile()} is called.
}
\examples{
\donttest{
x <- ggml_input(shape = 64L)
x <- ggml_input(shape = c(28L, 28L, 1L), name = "image")
x <- ggml_input(shape = 10L, dtype = "int32")  # token indices
}
}
