% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{ggml_graph_dump_dot}
\alias{ggml_graph_dump_dot}
\title{Export Graph to DOT Format}
\usage{
ggml_graph_dump_dot(graph, leafs = NULL, filename)
}
\arguments{
\item{graph}{Graph object}

\item{leafs}{Optional graph with leaf tensors (NULL for none)}

\item{filename}{Output filename (should end with .dot)}
}
\value{
No return value, called for side effects
}
\description{
Exports the computation graph to a DOT file for visualization.
The DOT file can be converted to an image using Graphviz tools.
}
\examples{
\donttest{
ctx <- ggml_init(16 * 1024 * 1024)
a <- ggml_new_tensor_1d(ctx, GGML_TYPE_F32, 10)
b <- ggml_relu(ctx, a)
graph <- ggml_build_forward_expand(ctx, b)
ggml_graph_dump_dot(graph, NULL, tempfile(fileext = ".dot"))
ggml_free(ctx)
}
}
