% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{ggml_fit_opt}
\alias{ggml_fit_opt}
\title{Fit model with R-side epoch loop and callbacks}
\usage{
ggml_fit_opt(
  sched,
  ctx_compute,
  inputs,
  outputs,
  dataset,
  loss_type = ggml_opt_loss_type_mse(),
  optimizer = ggml_opt_optimizer_type_adamw(),
  nepoch = 10L,
  nbatch_logical = 32L,
  val_split = 0,
  callbacks = list(),
  silent = FALSE
)
}
\arguments{
\item{sched}{Backend scheduler}

\item{ctx_compute}{Compute context (for temporary tensors)}

\item{inputs}{Input tensor with shape [ne_datapoint, batch_size]}

\item{outputs}{Output tensor with shape [ne_label, batch_size]}

\item{dataset}{Dataset created with `ggml_opt_dataset_init()`}

\item{loss_type}{Loss type (default: MSE)}

\item{optimizer}{Optimizer type (default: AdamW)}

\item{nepoch}{Number of epochs}

\item{nbatch_logical}{Logical batch size (for gradient accumulation)}

\item{val_split}{Fraction of data for validation (0.0 to 1.0)}

\item{callbacks}{List of callback lists. Each element may have
`on_epoch_begin(epoch, logs, state)` and/or `on_epoch_end(epoch, logs, state)`.
Built-in factories: `ggml_callback_early_stopping()`,
`ggml_schedule_step_decay()`, `ggml_schedule_cosine_decay()`,
`ggml_schedule_reduce_on_plateau()`.
`state` is a mutable environment with fields:
`stop` (set TRUE to stop training), `lr_ud`, `nepoch`.}

\item{silent}{Whether to suppress per-epoch progress output}
}
\value{
Data frame with columns epoch, train_loss, train_accuracy, val_loss, val_accuracy
}
\description{
Trains a model epoch by epoch in R, allowing callbacks for early stopping
and learning rate scheduling. Optimizer state (momentum) is preserved
across all epochs.
}
\examples{
if (FALSE) {
history <- ggml_fit_opt(sched, ctx_compute, inputs, outputs, dataset,
  nepoch = 50, val_split = 0.2,
  callbacks = list(
    ggml_callback_early_stopping(monitor = "val_loss", patience = 5),
    ggml_schedule_cosine_decay()
  ))
}
}
\seealso{
Other optimization: 
\code{\link{ggml_opt_alloc}()},
\code{\link{ggml_opt_context_optimizer_type}()},
\code{\link{ggml_opt_dataset_data}()},
\code{\link{ggml_opt_dataset_free}()},
\code{\link{ggml_opt_dataset_get_batch}()},
\code{\link{ggml_opt_dataset_init}()},
\code{\link{ggml_opt_dataset_labels}()},
\code{\link{ggml_opt_dataset_ndata}()},
\code{\link{ggml_opt_dataset_shuffle}()},
\code{\link{ggml_opt_default_params}()},
\code{\link{ggml_opt_epoch}()},
\code{\link{ggml_opt_eval}()},
\code{\link{ggml_opt_fit}()},
\code{\link{ggml_opt_free}()},
\code{\link{ggml_opt_get_lr}()},
\code{\link{ggml_opt_grad_acc}()},
\code{\link{ggml_opt_init}()},
\code{\link{ggml_opt_init_for_fit}()},
\code{\link{ggml_opt_inputs}()},
\code{\link{ggml_opt_labels}()},
\code{\link{ggml_opt_loss}()},
\code{\link{ggml_opt_loss_type_cross_entropy}()},
\code{\link{ggml_opt_loss_type_mean}()},
\code{\link{ggml_opt_loss_type_mse}()},
\code{\link{ggml_opt_loss_type_sum}()},
\code{\link{ggml_opt_ncorrect}()},
\code{\link{ggml_opt_optimizer_name}()},
\code{\link{ggml_opt_optimizer_type_adamw}()},
\code{\link{ggml_opt_optimizer_type_sgd}()},
\code{\link{ggml_opt_outputs}()},
\code{\link{ggml_opt_pred}()},
\code{\link{ggml_opt_prepare_alloc}()},
\code{\link{ggml_opt_reset}()},
\code{\link{ggml_opt_result_accuracy}()},
\code{\link{ggml_opt_result_free}()},
\code{\link{ggml_opt_result_init}()},
\code{\link{ggml_opt_result_loss}()},
\code{\link{ggml_opt_result_ndata}()},
\code{\link{ggml_opt_result_pred}()},
\code{\link{ggml_opt_result_reset}()},
\code{\link{ggml_opt_set_lr}()},
\code{\link{ggml_opt_static_graphs}()}
}
\concept{optimization}
