% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R, R/nn_model.R
\name{ggml_evaluate.ggml_functional_model}
\alias{ggml_evaluate.ggml_functional_model}
\alias{ggml_evaluate}
\alias{ggml_evaluate.ggml_sequential_model}
\title{Evaluate a Trained Model}
\usage{
\method{ggml_evaluate}{ggml_functional_model}(model, x, y, batch_size = 32L, ...)

ggml_evaluate(model, ...)

\method{ggml_evaluate}{ggml_sequential_model}(
  model,
  x,
  y,
  batch_size = 32,
  sample_weight = NULL,
  class_weight = NULL,
  ...
)
}
\arguments{
\item{model}{A trained ggml_sequential_model}

\item{x}{Test data}

\item{y}{Test labels (one-hot encoded)}

\item{batch_size}{Batch size for evaluation}

\item{...}{Additional arguments (ignored).}

\item{sample_weight}{Numeric vector of per-sample weights (length = nrow(x)).}

\item{class_weight}{Named vector of weights per class, e.g. c("0"=1, "1"=10). Cannot be used with sample_weight.}
}
\value{
Named list with \code{loss} and \code{accuracy}.
}
\description{
Evaluate a Trained Model
}
\examples{
\donttest{
n <- 128
x <- matrix(runif(n * 4), nrow = n, ncol = 4)
y <- matrix(0, nrow = n, ncol = 2)
for (i in seq_len(n)) { y[i, if (sum(x[i,]) > 2) 1L else 2L] <- 1 }

model <- ggml_model_sequential() |>
  ggml_layer_dense(8, activation = "relu") |>
  ggml_layer_dense(2, activation = "softmax")
model$input_shape <- 4L
model <- ggml_compile(model, optimizer = "adam",
                      loss = "categorical_crossentropy")
model <- ggml_fit(model, x, y, epochs = 5, batch_size = 32, verbose = 0)

# Basic evaluation
result <- ggml_evaluate(model, x, y, batch_size = 32)

# With sample_weight
sw <- runif(n, 0.5, 1.5)
result <- ggml_evaluate(model, x, y, batch_size = 32, sample_weight = sw)

# With class_weight
result <- ggml_evaluate(model, x, y, batch_size = 32,
                        class_weight = c("0" = 1, "1" = 2))
}
}
