% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_functional.R
\name{ggml_dense}
\alias{ggml_dense}
\title{Create a Dense Layer Object}
\usage{
ggml_dense(units, activation = NULL, name = NULL, trainable = TRUE)
}
\arguments{
\item{units}{Number of output units.}

\item{activation}{Activation function name or NULL.}

\item{name}{Optional character name.}

\item{trainable}{Logical; whether weights are updated during training.}
}
\value{
A \code{ggml_layer} object.
}
\description{
Returns a reusable layer object for use with \code{ggml_apply()}.
Applying the same object to multiple tensor nodes shares weights.
}
\examples{
\donttest{
encoder <- ggml_dense(64L, activation = "relu")
x1 <- ggml_input(shape = 32L)
x2 <- ggml_input(shape = 32L)
out1 <- x1 |> ggml_apply(encoder)
out2 <- x2 |> ggml_apply(encoder)  # shared weights
}
}
