% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggml.R
\docType{package}
\name{ggmlR-package}
\alias{ggmlR}
\alias{ggmlR-package}
\title{ggmlR: 'GGML' Tensor Operations for Machine Learning}
\description{
Provides 'R' bindings to the 'GGML' tensor library for machine learning, designed primarily for 'Vulkan' GPU acceleration with full CPU fallback. 'Vulkan' support is auto-detected at build time on Linux (when 'libvulkan-dev' and 'glslc' are installed) and on Windows (when 'Vulkan' 'SDK' is installed and 'VULKAN_SDK' environment variable is set); all operations fall back to CPU transparently when no GPU is available. Implements tensor operations, neural network layers, quantization, and a 'Keras'-like sequential model API for building and training networks. Includes 'AdamW' (Adam with Weight decay) and 'SGD' (Stochastic Gradient Descent) optimizers with 'MSE' (Mean Squared Error) and cross-entropy losses. Also provides a dynamic 'autograd' engine ('PyTorch'-style) with data-parallel training via 'dp_train()', broadcast arithmetic, 'f16' (half-precision) support on 'Vulkan' GPU, and a multi-head attention layer for building Transformer architectures. Serves as backend for 'LLM' (Large Language Model) inference via 'llamaR' and Stable Diffusion image generation via 'sdR'. See \url{https://github.com/ggml-org/ggml} for more information about the underlying library.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zabis13/ggmlR}
  \item Report bugs at \url{https://github.com/Zabis13/ggmlR/issues}
}

}
\author{
\strong{Maintainer}: Yuri Baramykov \email{lbsbmsu@mail.ru}

Other contributors:
\itemize{
  \item Georgi Gerganov (Author of the GGML library) [contributor, copyright holder]
  \item Jeffrey Quesnelle (Contributor to ops.cpp) [contributor, copyright holder]
  \item Bowen Peng (Contributor to ops.cpp) [contributor, copyright holder]
  \item Mozilla Foundation (Author of llamafile/sgemm.cpp) [contributor, copyright holder]
}

}
\keyword{internal}
