% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{ag_tensor}
\alias{ag_tensor}
\title{Create a dynamic tensor (no gradient tracking)}
\usage{
ag_tensor(
  data,
  device = .ag_device_state$device,
  dtype = .ag_device_state$dtype
)
}
\arguments{
\item{data}{Numeric matrix or vector}

\item{device}{\code{"cpu"} (default) or \code{"gpu"}. When \code{"gpu"},
compute operations will be dispatched to the ggml backend.}

\item{dtype}{Floating-point precision: \code{"f32"} (default), \code{"f16"},
or \code{"bf16"}. Ignored on CPU; controls upload precision on GPU.}
}
\value{
An ag_tensor object (environment)
}
\description{
ag_tensor is backed by an R environment so all references to the same
tensor see updates (like PyTorch tensors).
}
