% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{ag_gradcheck}
\alias{ag_gradcheck}
\title{Numerical gradient check (like torch.autograd.gradcheck)}
\usage{
ag_gradcheck(
  fn,
  inputs,
  eps = 1e-05,
  atol = 1e-04,
  verbose = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{fn}{A function that takes a list of ag_tensor inputs and returns a
scalar ag_tensor loss (must be used inside \code{with_grad_tape}).}

\item{inputs}{Named list of ag_tensor objects.  Only those with
\code{requires_grad = TRUE} are checked.}

\item{eps}{Finite-difference step size (default 1e-5).}

\item{atol}{Absolute tolerance for pass/fail (default 1e-4).}

\item{verbose}{Print per-element comparison (default FALSE).}

\item{quiet}{Suppress per-parameter and overall status lines (default FALSE).
Useful when calling from \code{testthat} tests to keep output clean.}
}
\value{
Invisibly \code{TRUE} if all gradients match, \code{FALSE} otherwise.
  When \code{quiet = FALSE} (default), prints a summary report.
}
\description{
Compares analytical gradients (from \code{backward()}) with finite-difference
numerical gradients for all input tensors with \code{requires_grad = TRUE}.
}
\examples{
\donttest{
W <- ag_param(matrix(runif(6), 2, 3))
x <- ag_tensor(matrix(runif(3), 3, 1))
ag_gradcheck(
  fn = function(ins) ag_mse_loss(ag_relu(ag_matmul(ins$W, ins$x)),
                                  matrix(0, 2, 1)),
  inputs = list(W = W, x = x)
)
}
}
