% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ag_layers.R
\name{ag_dropout}
\alias{ag_dropout}
\title{Create a Dropout layer}
\usage{
ag_dropout(rate)
}
\arguments{
\item{rate}{Drop probability in [0, 1)}
}
\value{
An \code{ag_dropout} environment
}
\description{
In training mode applies inverted dropout (random Bernoulli mask, scale by
\code{1/(1-rate)} to preserve expected values).  In eval mode is identity.
}
\examples{
\donttest{
drop <- ag_dropout(0.5)
x    <- ag_tensor(matrix(runif(8), 4, 2))
out  <- drop$forward(x)  # training mode by default
ag_eval(drop)
out2 <- drop$forward(x)  # identity
}
}
