% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autograd.R
\name{ag_cross_entropy_loss}
\alias{ag_cross_entropy_loss}
\title{Categorical Cross-Entropy loss}
\usage{
ag_cross_entropy_loss(pred, target)
}
\arguments{
\item{pred}{ag_tensor [classes, batch_size]  probabilities (any, not just softmax)}

\item{target}{matrix [classes, batch_size]   one-hot (or soft) labels}
}
\value{
scalar ag_tensor
}
\description{
Generic CE: \code{-sum(target * log(pred)) / batch_size}.
The gradient w.r.t. \code{pred} is \code{-target / pred / n}.
Use \code{ag_softmax_cross_entropy_loss()} for the numerically stable
combined softmax + CE (fused gradient \code{(p - y) / n}).
}
