% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizer.R
\name{ggml_opt_fit}
\alias{ggml_opt_fit}
\title{Fit model to dataset}
\usage{
ggml_opt_fit(
  sched,
  ctx_compute,
  inputs,
  outputs,
  dataset,
  loss_type = ggml_opt_loss_type_mse(),
  optimizer = ggml_opt_optimizer_type_adamw(),
  nepoch = 1,
  nbatch_logical = 32,
  val_split = 0,
  silent = FALSE
)
}
\arguments{
\item{sched}{Backend scheduler}

\item{ctx_compute}{Compute context (for temporary tensors)}

\item{inputs}{Input tensor with shape [ne_datapoint, batch_size]}

\item{outputs}{Output tensor with shape [ne_label, batch_size]}

\item{dataset}{Dataset created with ggml_opt_dataset_init}

\item{loss_type}{Loss type (default: MSE)}

\item{optimizer}{Optimizer type (default: AdamW)}

\item{nepoch}{Number of epochs}

\item{nbatch_logical}{Logical batch size (for gradient accumulation)}

\item{val_split}{Fraction of data for validation (0.0 to 1.0)}

\item{silent}{Whether to suppress progress output}
}
\value{
NULL invisibly
}
\description{
High-level function to train a model on a dataset.
This is the recommended way to train models.
}
\examples{
# Full training requires building a computation graph
# See package vignettes for complete examples
if (FALSE) {
cpu <- ggml_backend_cpu_init()
sched <- ggml_backend_sched_new(list(cpu))
dataset <- ggml_opt_dataset_init(GGML_TYPE_F32, GGML_TYPE_F32, 10, 1, 1000)
# ... build model graph with ctx_compute, inputs, outputs ...
ggml_opt_fit(sched, ctx_compute, inputs, outputs, dataset,
             nepoch = 10, val_split = 0.1)
ggml_opt_dataset_free(dataset)
ggml_backend_sched_free(sched)
ggml_backend_free(cpu)
}
}
\seealso{
Other optimization: 
\code{\link{ggml_opt_alloc}()},
\code{\link{ggml_opt_context_optimizer_type}()},
\code{\link{ggml_opt_dataset_data}()},
\code{\link{ggml_opt_dataset_free}()},
\code{\link{ggml_opt_dataset_get_batch}()},
\code{\link{ggml_opt_dataset_init}()},
\code{\link{ggml_opt_dataset_labels}()},
\code{\link{ggml_opt_dataset_ndata}()},
\code{\link{ggml_opt_dataset_shuffle}()},
\code{\link{ggml_opt_default_params}()},
\code{\link{ggml_opt_epoch}()},
\code{\link{ggml_opt_eval}()},
\code{\link{ggml_opt_free}()},
\code{\link{ggml_opt_grad_acc}()},
\code{\link{ggml_opt_init}()},
\code{\link{ggml_opt_inputs}()},
\code{\link{ggml_opt_labels}()},
\code{\link{ggml_opt_loss}()},
\code{\link{ggml_opt_loss_type_cross_entropy}()},
\code{\link{ggml_opt_loss_type_mean}()},
\code{\link{ggml_opt_loss_type_mse}()},
\code{\link{ggml_opt_loss_type_sum}()},
\code{\link{ggml_opt_ncorrect}()},
\code{\link{ggml_opt_optimizer_name}()},
\code{\link{ggml_opt_optimizer_type_adamw}()},
\code{\link{ggml_opt_optimizer_type_sgd}()},
\code{\link{ggml_opt_outputs}()},
\code{\link{ggml_opt_pred}()},
\code{\link{ggml_opt_prepare_alloc}()},
\code{\link{ggml_opt_reset}()},
\code{\link{ggml_opt_result_accuracy}()},
\code{\link{ggml_opt_result_free}()},
\code{\link{ggml_opt_result_init}()},
\code{\link{ggml_opt_result_loss}()},
\code{\link{ggml_opt_result_ndata}()},
\code{\link{ggml_opt_result_pred}()},
\code{\link{ggml_opt_result_reset}()},
\code{\link{ggml_opt_static_graphs}()}
}
\concept{optimization}
