% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_colour_ramp.R
\name{ramp_colours}
\alias{ramp_colours}
\title{Apply partial colour ramps}
\usage{
ramp_colours(colour, ramp)
}
\arguments{
\item{colour}{<\link{character}> Vector of colours to ramp to.}

\item{ramp}{<\link{partial_colour_ramp}> Vector of colour ramps (same length as
\code{colour}) giving the colour to ramp from and the amount to ramp.}
}
\value{
A character vector of colours.
}
\description{
Given vectors of colours and \code{\link{partial_colour_ramp}}s, ramps the colours
according to the parameters of the partial colour ramps, returning
a vector of the same length as the inputs giving the transformed
(ramped) colours.
}
\details{
Takes vectors of colours and \code{\link{partial_colour_ramp}}s and produces
colours by interpolating between each \code{from} colour and the target \code{colour}
the specified \code{amount} (where \code{amount} and \code{from} are the corresponding
fields of the \code{ramp}).

For example, to add support for the \code{fill_ramp} aesthetic to a geometry,
this line could be used inside the \code{draw_group()} or \code{draw_panel()} method
of a geom:

\if{html}{\out{<div class="sourceCode">}}\preformatted{data$fill = ramp_colours(data$fill, data$fill_ramp)
}\if{html}{\out{</div>}}
}
\examples{
pcr = partial_colour_ramp(c(0, 0.25, 0.75, 1), "red")
pcr

ramp_colours("blue", pcr)
}
\seealso{
Other colour ramp functions: 
\code{\link{guide_rampbar}()},
\code{\link{partial_colour_ramp}()},
\code{\link{scale_colour_ramp}}
}
\author{
Matthew Kay
}
\concept{colour ramp functions}
