% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_dag.R
\name{as_tidy_dagitty}
\alias{as_tidy_dagitty}
\alias{as_tidy_dagitty.dagitty}
\alias{as_tidy_dagitty.data.frame}
\title{Convert objects into \code{tidy_dagitty} objects}
\usage{
as_tidy_dagitty(x, ...)

\method{as_tidy_dagitty}{dagitty}(x, seed = NULL, layout = "nicely", ...)

\method{as_tidy_dagitty}{data.frame}(x, seed = NULL, layout = "nicely", ...)
}
\arguments{
\item{x}{An object to convert into a \code{tidy_dagitty}. Currently supports
\code{dagitty} and \code{data.frame} objects.}

\item{...}{optional arguments passed to \code{ggraph::create_layout()}}

\item{seed}{a numeric seed for reproducible layout generation}

\item{layout}{a layout available in \code{ggraph}. See \code{\link[ggraph:ggraph]{ggraph::create_layout()}}
for details. Alternatively, \code{"time_ordered"} will use
\code{time_ordered_coords()} to algorithmically sort the graph by time.}
}
\value{
a \code{tidy_dagitty} object
}
\description{
An alternative API and specification to \code{\link[=tidy_dagitty]{tidy_dagitty()}}, \code{as_tidy_dagitty()}
allows you to create \code{tidy_dagitty} objects from data frames. There is also a
method for \code{dagitty} objects, which is a thin wrapper for \code{\link[=tidy_dagitty]{tidy_dagitty()}}.
To create a DAG from a data frame, it must contain \code{name} and \code{to} columns,
representing the nodes and any edges leading from the nodes. If there are
\code{x}, \code{y}, \code{xend}, and \code{yend} columns, they will be used as coordinates.
Otherwise, \code{layout} will be used. See \link{tidy_dagitty} for more information
about layouts. Additionally, you can specify status (one of \code{exposure},
\code{outcome}, or \code{latent}) by including a \code{status} column. Any other columns in
the data set will also be joined to the \code{tidy_dagitty} data.
}
\examples{

data.frame(name = c("c", "c", "x"), to = c("x", "y", "y")) \%>\%
  as_tidy_dagitty()

}
\seealso{
\code{\link[=tidy_dagitty]{tidy_dagitty()}}, \code{\link[=pull_dag]{pull_dag()}}
}
