% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstack_options.R
\name{ggstack_options}
\alias{ggstack_options}
\title{Visual Parameters for ggstack Plots}
\usage{
ggstack_options(
  colours_default = c("#66C2A5", "#FC8D62", "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F",
    "#E5C494"),
  colours_default_logical = c(`TRUE` = "#648fff", `FALSE` = "#dc267f"),
  colours_missing = "grey90",
  show_legend_titles = FALSE,
  legend_title_position = c("top", "bottom", "left", "right"),
  legend_nrow = 4,
  legend_ncol = NULL,
  legend_title_size = NULL,
  legend_text_size = NULL,
  legend_key_size = 0.3,
  legend_orientation_heatmap = c("horizontal", "vertical"),
  show_legend = TRUE,
  legend_position = c("right", "left", "bottom", "top"),
  na_marker = "!",
  na_marker_size = 8,
  na_marker_colour = "black",
  show_na_marker_categorical = FALSE,
  show_na_marker_heatmap = FALSE,
  colours_heatmap_low = "purple",
  colours_heatmap_high = "seagreen",
  transform_heatmap = c("identity", "log10", "log2"),
  fontsize_values_heatmap = 3,
  show_values_heatmap = FALSE,
  colours_values_heatmap = "white",
  vertical_spacing = 0,
  numeric_plot_type = c("bar", "heatmap"),
  y_axis_position = c("left", "right"),
  width = 0.9,
  relative_height_numeric = 4,
  cli_header = "Running ggstack",
  interactive_svg_width = NULL,
  interactive_svg_height = NULL,
  fontsize_barplot_y_numbers = 8,
  max_digits_barplot_y_numbers = 3,
  fontsize_y_title = 12,
  beautify_text = TRUE,
  beautify_values = FALSE,
  beautify_function = beautify
)
}
\arguments{
\item{colours_default}{Default colors for categorical variables without a custom palette.}

\item{colours_default_logical}{Colors for binary variables: a vector of three colors representing \code{TRUE}, \code{FALSE}, and \code{NA} respectively (character).}

\item{colours_missing}{Color for missing (\code{NA}) values in categorical plots (string).}

\item{show_legend_titles}{Display titles for legends (flag).}

\item{legend_title_position}{Position of the legend title ("top", "bottom", "left", "right").}

\item{legend_nrow}{Number of rows in the legend (number).}

\item{legend_ncol}{Number of columns in the legend. If set, \code{legend_nrow} should be \code{NULL} (number).}

\item{legend_title_size}{Size of the legend title text (number).}

\item{legend_text_size}{Size of the text within the legend (number).}

\item{legend_key_size}{Size of the legend key symbols (number).}

\item{legend_orientation_heatmap}{should legend orientation be "horizontal" or "vertical".}

\item{show_legend}{Display the legend on the plot (flag).}

\item{legend_position}{Position of the legend ("right", "left", "bottom", "top").}

\item{na_marker}{Text used to mark \code{NA} values in numeric plots (string).}

\item{na_marker_size}{Size of the text marker for \code{NA} values (number).}

\item{na_marker_colour}{Color of the \code{NA} text marker (string).}

\item{show_na_marker_categorical}{Show a marker for \code{NA} and \code{Infinite} values on categorical tiles (flag).}

\item{show_na_marker_heatmap}{Show a marker for \code{NA} values on heatmap tiles (flag).}

\item{colours_heatmap_low}{Color for the lowest value in heatmaps (string).}

\item{colours_heatmap_high}{Color for the highest value in heatmaps (string).}

\item{transform_heatmap}{Transformation to apply before visualizing heatmap values ("identity", "log10", "log2").}

\item{fontsize_values_heatmap}{Font size for heatmap values (number).}

\item{show_values_heatmap}{Display numerical values on heatmap tiles (flag).}

\item{colours_values_heatmap}{Color for heatmap values (string).}

\item{vertical_spacing}{Space between each data row in points (number).}

\item{numeric_plot_type}{Type of visualization for numeric data: "bar" or "heatmap".}

\item{y_axis_position}{Position of the y-axis ("left" or "right").}

\item{width}{controls how much space is present between bars and tiles within each plot. Can be 0-1 where values of 1 makes bars/tiles take up 100\% of available space (no gaps between bars).}

\item{relative_height_numeric}{how many times taller should numeric plots be relative to categorical tile plots. Only taken into account if numeric_plot_type == "bar" (number)}

\item{cli_header}{Text used for h1 header. Included so it can be tweaked by packages that use ggstack, so they can customise how the info messages appear.}

\item{interactive_svg_width, interactive_svg_height}{width and height of the interactive graphic region (in inches). Only used when \code{interactive = TRUE}.}

\item{fontsize_barplot_y_numbers}{fontsize of the text describing numeric barplot max & min values (number).}

\item{max_digits_barplot_y_numbers}{Number of digits to round the numeric barplot max and min values to (number).}

\item{fontsize_y_title}{fontsize of the y axis titles (a.k.a the data.frame column names) (number).}

\item{beautify_text}{Beautify y-axis text and legend titles  to more human-readable forms (e.g. converting 'my_title' to 'My Title') (flag).}

\item{beautify_values}{Beautify legend values to more human-readable forms (e.g. converting 'my_value' to 'My Value') (flag)}

\item{beautify_function}{a function that takes a string and returns a nicely formatted string. Use to beautify axis & legend titles when \code{beautify_text=TRUE}, and legend values when \code{beautify_values=TRUE}.}
}
\value{
A list of visualization parameters for \code{ggstack}.
}
\description{
Configures aesthetic and layout settings for plots generated by \code{ggstack}.
}
\examples{

# Create Basic Plot
ggstack(baseballfans, col_id = "ID", col_sort = "Glasses")

# Configure plot ggstack_options()
ggstack(
  lazy_birdwatcher,
  col_sort = "Magpies",
  palettes = list(
    Birdwatcher = c(Robert = "#E69F00", Catherine = "#999999"),
    Day = c(Weekday = "#999999", Weekend = "#009E73")
  ),
  options = ggstack_options(
    show_legend = TRUE,
    fontsize_barplot_y_numbers = 12,
    legend_text_size = 16,
    legend_key_size = 1,
    legend_nrow = 1,
  )
)

}
