% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookorg_bib.R
\name{bookorg_bib}
\alias{bookorg_bib}
\title{Function for preparing book metadata with organizers for automatic insertion into scientific articles}
\usage{
bookorg_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a book with organizers}

\item{input_tam}{is the length of the dataframe with the book with organizers, obtained using package bibliorefer.}
}
\value{
The output of the bookorg_bib function is the file with the .bib extension of books with organizers in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\description{
The bookorg_bib function prepares the metadata of books with organizers to be automatically included in a scientific article. The bookorg_bib function internally calls two support functions. The output of the bookorg_bib function is the file with the .bib extension of books with organizers in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","bookorg.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 9

#Calls the function bookorg_bib
bookorglister_bibtex <- bookorg_bib(input_date, input_tam)
bookorglister_bibtex



}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
