% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/book_bib.R
\name{book_bib}
\alias{book_bib}
\title{Function to prepare book metadata for automatic insertion into scientific articles}
\usage{
book_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a books}

\item{input_tam}{is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.}
}
\value{
The output of the book_bib function is the file with the .bib extension, of the books in BibTex format, prepared to be automatically in the list of references of a scientific article.
}
\description{
The book_bib function prepares the metadata of books to be automatically included in a scientific article. The book_bib function internally calls two support functions. The output of the book_bib function is the file with the .bib extension, of the books in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","livro.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 5

#Calls the function book_bib
booklister_bibtex <- book_bib(input_date, input_tam)
booklister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
