% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersect.R
\name{geodesic_intersect}
\alias{geodesic_intersect}
\alias{geodesic_intersect_segment}
\alias{geodesic_intersect_next}
\alias{geodesic_intersect_all}
\title{Geodesic intersections}
\usage{
geodesic_intersect(x, azi_x, y, azi_y)

geodesic_intersect_segment(x1, x2, y1, y2)

geodesic_intersect_next(x, azi_x, azi_y)

geodesic_intersect_all(x, azi_x, y, azi_y, maxdist)
}
\arguments{
\item{x}{Coordinates for geodesic X: a vector of \code{c(lon, lat)}, a matrix
with columns \verb{[lon, lat]}, or a list with \code{lon} and \code{lat} components.}

\item{azi_x}{Azimuth(s) for geodesic X in degrees.}

\item{y}{Coordinates for geodesic Y (same format as \code{x}).}

\item{azi_y}{Azimuth(s) for geodesic Y in degrees.}

\item{x1, x2}{Start and end coordinates for segment X.}

\item{y1, y2}{Start and end coordinates for segment Y.}

\item{maxdist}{Maximum distance (in meters) for finding all intersections.}
}
\value{
A data frame with columns:
\itemize{
\item \code{x} - Displacement along geodesic X from its starting point (meters)
\item \code{y} - Displacement along geodesic Y from its starting point (meters)
\item \code{coincidence} - Indicator: 0 = normal intersection, +1 = geodesics are
parallel and coincident, -1 = geodesics are antiparallel and coincident
\item \code{lat} - Latitude of intersection point (degrees)
\item \code{lon} - Longitude of intersection point (degrees)
}

For \code{geodesic_intersect_segment()}, an additional column \code{segmode} indicates
whether the intersection lies within both segments (0), or which segment(s)
the intersection lies outside of.

For \code{geodesic_intersect_all()}, returns a list of data frames (one per input
pair of geodesics).
}
\description{
Find the intersection of two geodesics on the WGS84 ellipsoid. Several
methods are available:
\itemize{
\item \code{geodesic_intersect()} - Find the closest intersection of two geodesics
defined by starting points and azimuths
\item \code{geodesic_intersect_segment()} - Find the intersection of two geodesic
segments defined by their endpoints
\item \code{geodesic_intersect_next()} - Find the next closest intersection from a
known intersection point
\item \code{geodesic_intersect_all()} - Find all intersections within a maximum
distance
}
}
\details{
The intersection point is found using the algorithm described in:

C. F. F. Karney, "Geodesic intersections", J. Surveying Eng. 150(3),
04024005:1-9 (2024). \doi{10.1061/JSUED2.SUENG-1483}

The "closest" intersection minimizes the L1 distance, defined as
\verb{|x| + |y|} where \code{x} and \code{y} are the displacements along the two geodesics.

For segment intersection, \code{segmode} encodes whether the intersection lies
within the segments:
\itemize{
\item \code{segmode = 0} means the intersection lies within both segments
\item Non-zero values indicate the intersection lies outside one or both segments
}

The coincidence indicator is useful for detecting when geodesics are
parallel or antiparallel at their intersection.
}
\examples{
# Two geodesics from different starting points
# Geodesic X: starts at (0, 0), azimuth 45 degrees
# Geodesic Y: starts at (1, 0), azimuth 315 degrees
geodesic_intersect(c(0, 0), 45, c(1, 0), 315)

# Vectorized: multiple pairs of geodesics
geodesic_intersect(
  cbind(c(0, 0, 0), c(0, 0, 0)),
  c(30, 45, 60),
  cbind(c(1, 1, 1), c(0, 0, 0)),
  c(330, 315, 300)
)
# Intersection of two geodesic segments
# Segment X: (0, -1) to (0, 1)
# Segment Y: (-1, 0) to (1, 0)
geodesic_intersect_segment(
  c(0, -1), c(0, 1),
  c(-1, 0), c(1, 0)
)
# Find the next intersection from a known intersection point
# Two geodesics crossing at (0, 0) with azimuths 45 and 315
geodesic_intersect_next(c(0, 0), 45, 315)
# Find all intersections within 1,000,000 meters
geodesic_intersect_all(c(0, 0), 45, c(1, 0), 315, maxdist = 1e6)
}
\seealso{
\code{\link[=geodesic_inverse]{geodesic_inverse()}} for computing azimuths between points
}
