% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basics.R
\name{sq}
\alias{sq}
\title{Calculates the Root Mean Square Roughness of a Surface}
\usage{
sq(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A value of root mean square roughness in
  the units of the original raster or matrix.
}
\description{
Finds the root mean square roughness of a surface
(Sq) as the standard deviation of surface heights
from the mean surface height. Height is measured as
the value of a raster and may not necessarily
represent actual height.
}
\examples{
# import raster image
data(normforest)
normforest <- terra::unwrap(normforest)

# find the surface roughness
roughness <- sq(normforest)
}
