% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bestfitplane}
\alias{bestfitplane}
\title{Finds the Best Fit Polynomial Surface}
\usage{
bestfitplane(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A raster or matrix of the same size as the input with values
  predicted from the best polynomial fit.
}
\description{
Finds the best fit polynomial surface for a raster or matrix. This
function tests least squares polynomial fits with orders of
0 - 3 and determines which order minimizes the error when the
fit is subtracted from the original image.
}
\examples{

# import raster image
data(orforest)
orforest <- terra::unwrap(orforest)

# find the least squares polynomial surface
poly <- bestfitplane(orforest)

# plot the fit
terra::plot(poly)
}
