% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hfr.R
\name{get_hfr}
\alias{get_hfr}
\title{Create a hyperframe}
\usage{
get_hfr(
  data,
  col,
  window,
  time_col,
  time_range,
  coordinates = c("longitude", "latitude"),
  combine = TRUE,
  input_crs = 4326,
  unit_scale = 1000
)
}
\arguments{
\item{data}{dataframe. The dataframe must have time and location variables.}

\item{col}{the name of the column for types of events of interest}

\item{window}{owin object (for more information, refer to `spatstat.geom::owin()`).
Must be a projected window (e.g., created via \code{get_window} with a \code{target_crs}
specified). This function automatically detects the projection from the window and projects
the event data accordingly.}

\item{time_col}{the name of the column for time variable. Note that the time variable must be integers.}

\item{time_range}{numeric vector. `time_range` specifies the range of the time variable
(i.e., min and max of the time variable).
The current version assumes that the unit of this time variable is dates.}

\item{coordinates}{character vector. `coordinates` specifies the names of columns for locations.
By default, `c("longitude", "latitude")` in this order. Note that the coordinates must be in decimal degree formats.}

\item{combine}{logical. `combine` tells whether to generate output for all subtypes of events combined.
By default, `TRUE`, which means that a column of ppp objects with all subtypes combined is generated in the output.}

\item{input_crs}{the CRS of the input \code{coordinates}. Defaults to \code{4326}
(WGS84 decimal degrees). The function will transform these to match the \code{window} projection}

\item{unit_scale}{parameter to convert meters to kilometers}
}
\value{
A hyperframe is generated with rows representing time and columns representing the following:
    * The first column: time variable
    * The middle columns: ppp objects (see `spatstat.geom::ppp()`) generated for each subtype of events of interest
    * The last column (if `combine = TRUE`): ppp objects with all subtypes combined. This column is named as `all_combined`.
}
\description{
`get_hfr()` takes a dataframe with time and location variables
and generates a hyperframe with point patterns.
}
\examples{
# Data
dat <- data.frame(time = c(1, 1, 2, 2),
                  longitude = c(43.9, 44.5, 44.1, 44.0),
                  latitude = c(33.6, 32.7, 33.6, 33.5),
                  type = rep(c("treat", "out"), 2))

# Hyperframe
get_hfr(data = dat,
        col = "type",
        window = iraq_window,
        time_col = "time",
        time_range = c(1, 2),
        coordinates = c("longitude", "latitude"),
        combine = FALSE)
}
