library(testthat)

test_that("rss.t.test works as expected",{
  set.seed(123)
  rss.data=rss.simulation(H=3,nsamp=c(6,6,6),dist="normal", rho=0.8,delta=0)
  result=rss.t.test(data1=rss.data, data2=NULL, alpha=0.05,alternative="two.sided", mu0=0, method='sample')
  expect_equal(result$RSS_mean, 0.0907, tolerance = 1e-3)
  expect_equal(result$t, 0.570, tolerance = 1e-3)
  expect_equal(result$p.value, 0.579, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.256,0.437), tolerance = 1e-3)
  expect_equal(result$df, 12.082, tolerance = 1e-3)

  set.seed(123)
  rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  result=rss.t.test(data1=rss.data, data2=rss.data2, alpha=0.05, alternative="two.sided", mu0=0, method='naive')
  expect_equal(result$RSS_mean, c(0.0907,-0.05269), tolerance = 1e-3)
  expect_equal(result$t, 1.1199, tolerance = 1e-3)
  expect_equal(result$p.value, 0.2701, tolerance = 1e-3)
  expect_equal(result$CI, c(-0.1163,0.40320), tolerance = 1e-3)
  expect_equal(result$df, 36, tolerance = 1e-3)

})

test_that("rss.t.test handles wrong input with error",{
  rss.data=rss.simulation(H=3,nsamp=c(6,7,8),dist="normal", rho=0.8,delta=0)
  rss.data2<-rss.simulation(H=3,nsamp=c(6,8,10),dist="normal", rho=0.8,delta=0)
  rss.data3<-rss.simulation(H=4,nsamp=c(6,8,10,6),dist="normal", rho=0.8,delta=0)
  expect_error(rss.t.test(data1=rss.data, data2=NULL, alpha=1.1,alternative="two.sided", mu0=0, method="sample"),
               "alpha is out of bound.")
  expect_error(rss.t.test(data1=rss.data, data2=NULL, alpha=0.05,alternative="one-sided", mu0=0, method="sample"),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.t.test(data1=rss.data[,1], data2=NULL, alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.t.test(data1=rss.data[,2], data2=NULL, alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The input data must contain 'rank' and 'y' variables.")
  expect_error(rss.t.test(data1=rss.data, data2=rss.data2, alpha=0,alternative="two.sided", mu0=0, method="sample"),
               "alpha is out of bound.")
  expect_error(rss.t.test(data1=rss.data, data2=rss.data2, alpha=0.05,alternative="one-sided", mu0=0, method="sample"),
               "Invalid alternative selected. Please choose from 'two.sided', 'less', or 'greater'.")
  expect_error(rss.t.test(data1=rss.data3, data2=rss.data2, alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "Set sizes are different.")
  expect_error(rss.t.test(data1=rss.data3[,1], data2=rss.data2, alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The first input data must contain 'rank' and 'y' variables.")
  expect_error(rss.t.test(data1=rss.data3[,2], data2=rss.data2, alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The first input data must contain 'rank' and 'y' variables.")
  expect_error(rss.t.test(data1=rss.data3, data2=rss.data2[,1], alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The second input data must contain 'rank' and 'y' variables.")
  expect_error(rss.t.test(data1=rss.data3, data2=rss.data2[,2], alpha=0.05,alternative="two.sided", mu0=0, method="sample"),
               "The second input data must contain 'rank' and 'y' variables.")
})
