% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.prop.simulation.R
\name{rss.prop.simulation}
\alias{rss.prop.simulation}
\title{Generate example ranked set samples for proportions}
\usage{
rss.prop.simulation(H, nsamp, p)
}
\arguments{
\item{H}{The RSS set size.}

\item{nsamp}{A numeric vector specifying the sample allocation for each stratum.}

\item{p}{The true population proportion.}
}
\value{
\item{rank}{The rank information assigned to each sample.}
\item{y}{The generated ranked set samples (binary values) based on the population proportion.}
}
\description{
The rss.prop.simulation function generates ranked set samples for proportions by simulating data with options to adjust the population proportion (p).
}
\details{
This function simulates balanced or unbalanced RSS sampling for proportions. The length of the sample allocation vector (nsamp) must match the set size (H). The p parameter adjusts the true population proportion. The simulations assumes perfect ranking.
}
\examples{
## Balanced RSS with a set size 3 and equal sample sizes of 6 for each stratum,
## using perfect ranking with true proportion of 0.6.
rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,6,6),p=0.6)

## Unbalanced RSS with a set size 3 and different sample sizes of 6, 10, and 8 for each stratum,
## using perfect ranking with true proportion of 0.2.
rss.prop.data=rss.prop.simulation(H=3,nsamp=c(6,10,8),p=0.2)

# Check the structure of the RSS data
colnames(rss.prop.data) # Should include "y" and "rank"
head(rss.prop.data$y)
head(rss.prop.data$rank)

}
