% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Genepop.R
\name{Fst}
\alias{Fst}
\title{Fst (or rho_ST) estimation}
\usage{
Fst(
  inputFile,
  sizes = FALSE,
  pairs = FALSE,
  outputFile = "",
  dataType = "Diploid",
  verbose = interactive()
)
}
\arguments{
\item{inputFile}{The path of the input file, in Genepop format}

\item{sizes}{logical: whether to estimate allele-size based statistics, or identity-based Fst}

\item{pairs}{whether to estimate differentiation between all pairs of populations, or to compute a global estimate for all populations}

\item{outputFile}{character: The path of the output file}

\item{dataType}{character: The haploid and diploid data}

\item{verbose}{logical: whether to print some information}
}
\value{
The path of the output file is returned invisibly.
}
\description{
Evaluates Fst or related measures based on allele sizes, for all populations of for all pairs of populations. See \href{../doc/all-menu-options.html#sub-options-14-f-statistics-and-rho-statistics}{this section} of the Genepop executable documentation for more information on the statistical methods.
}
\examples{
locinfile <- genepopExample('sample.txt')
Fst(locinfile, outputFile= 'sample.txt.DIV')
if ( ! interactive()) clean_workdir(otherfiles='sample.txt')
}
