% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustdisc.R
\name{robust_disc}
\alias{robust_disc}
\title{univariate discretization based on offline change point detection}
\usage{
robust_disc(formula, data, discnum, minsize = 1, cores = 1)
}
\arguments{
\item{formula}{A formula of univariate discretization.}

\item{data}{A data.frame or tibble of observation data.}

\item{discnum}{A numeric vector of discretized classes of columns that need to be discretized.}

\item{minsize}{(optional) The min size of each discretization group. Default all use \code{1}.}

\item{cores}{(optional) A positive integer(default is 1). If cores > 1, use \code{python} \code{joblib} package to
parallel computation.}
}
\value{
A \code{tibble}.
}
\description{
Determines discretization interval breaks using an optimization algorithm for variance-based
change point detection.
}
\examples{
data('sim')
\donttest{
tryCatch({
  robust_disc(y ~ xa, data = sim, discnum = 5)
  robust_disc(y ~ .,
              data = dplyr::select(sim,-dplyr::any_of(c('lo','la'))),
              discnum = 5, cores = 3)
}, error = \(e) message("Skipping Python-dependent example: ", e$message))
}
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
