% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammaFuncModel.R
\name{grpResp2Time_parallel}
\alias{grpResp2Time_parallel}
\title{Vectorized version of grpRes2Time()}
\usage{
grpResp2Time_parallel(
  df,
  met_vec,
  covariates,
  time_terms = c("Time", "log(Time)"),
  grp = "Diet",
  random_formula = ~1 | ID,
  correlation_formula = corAR1(form = ~Time | ID),
  weights = NULL
)
}
\arguments{
\item{df}{Data frame containing information for a single group, containing columns grp; ID(subject ID: character); Time(positive: numeric); other Time terms (numeric); other individual characteristics covariates; as well columns of metabolite concentrations
Note: All non-concentration columns must be complete (No missing values); concentration columns can have missing values in the forms of either numeric 0 or 'NA'.}

\item{met_vec}{Vector of metabolite names}

\item{covariates}{Vector containing the names of the "ID" covariate, grouping covariate and other covariates excluding any "Time" covariates}

\item{time_terms}{Vector that contains all additional form of the covariate 'Time" (including the 'Time' covariate), and must contain 'log(Time)', other forms also include I(Time^2) and I(Time^3);}

\item{grp}{Grouping variable (should be a single valued column);}

\item{random_formula}{Random effects formula for the model, within ID (could also add random slope for 'Time');}

\item{correlation_formula}{Correlation formula. Default is autorgressive but can accommodate other forms such as unstructured covariance or exponential covariance;}

\item{weights}{specify a variance function that models heteroscedasticity}
}
\value{
Data frame that contains the coefficient estimates, their corresponding p-values as well as LRT p-values for 'Time' terms
}
\description{
Vectorized version of grpRes2Time()
}
\note{
This function uses parallel processing via the `future.apply` package.
To enable parallel execution, runs the following before calling this function:

  library(future.apply)
  plan(multisession, workers = parallel::detectCores() - 1)

You only need to set the plan once per session.
}
\examples{
\donttest{
require(gammaFuncModel)
require(dplyr)
require(nlme)
df <- data.frame(
  ID = rep(sprintf("\%02d", 1:10), each = 9 * 3),  
  Time = rep(rep(1:9, each = 3), 10),            
  Diet = as.factor(rep(1:3, times = 9 * 10)),    
  Age = rep(sample(20:70, 10, replace = TRUE), each = 9 * 3), 
  BMI = round(rep(runif(10, 18.5, 35), each = 9 * 3), 1)    
)
metvar <- paste0("met", 1:10)
concentration_data <- replicate(10, round(runif(270, 5, 15), 2))
colnames(concentration_data) <- metvar[1:10]
df <- cbind(df, as.data.frame(concentration_data))
df_single_diet <- subset(df, Diet == 1)
covariates <- c("ID","Diet", "Age", "BMI")
library(future.apply)
plan(multisession, workers = parallel::detectCores() - 1)
result_SD <- grpResp2Time_parallel(df_single_diet, metvar, covariates)[[1]]
summary(result_SD)
}
}
\references{
Wickham, H. (2022). dplyr: A Grammar of Data Manipulation. R package version 1.0.10. 
Available at: \url{https://CRAN.R-project.org/package=dplyr}

Pinheiro, J. C., & Bates, D. M. (2022). nlme: Linear and Nonlinear Mixed Effects Models. R package version 3.1-153.
Available at: \url{https://CRAN.R-project.org/package=nlme}
}
