% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compound.R
\name{compound}
\alias{compound}
\alias{compound.data_request}
\alias{compound.metadata_request}
\alias{compound.files_request}
\alias{compound.prequery}
\alias{compound.query}
\alias{compound.query_set}
\title{Force evaluation of a database query}
\usage{
compound(x, ...)

\method{compound}{data_request}(x, mint_doi = FALSE, ...)

\method{compound}{metadata_request}(x, ...)

\method{compound}{files_request}(x, ...)

\method{compound}{prequery}(x, mint_doi = FALSE, ...)

\method{compound}{query}(x, ...)

\method{compound}{query_set}(x, ...)
}
\arguments{
\item{x}{An object to be compounded. Works for \code{data_request},
\code{metadata_request}, \code{file_request}, \code{query} or \code{prequery}.}

\item{...}{Other arguments passed to \code{\link[=capture]{capture()}}.}

\item{mint_doi}{Logical: should a DOI be minted for this download? Only
applies to \code{type = "occurrences"}, and only for supported atlases.}
}
\value{
An object of class \code{query_set}, which is simply a list of all \code{query}
objects required to properly evaluate the specified request. Objects are
listed in the order in which they will be evaluated, meaning the query
that the user has actually requested will be placed last.
}
\description{
\code{\link[=compound]{compound()}} shows the full set of queries
required to properly evaluate the user's request, run prior to \code{\link[=collapse]{collapse()}}.

The number of total queries to send for a single data request is often broader
than the single query returned by \code{\link[=collapse]{collapse()}}. If, for example,
the user's query includes a call to
\code{\link[=identify.data_request]{identify()}}, then a taxonomic query
is required to run \emph{before} the 'final' query is attempted. In relation to
other functions that manipulate \verb{_request} objects, \code{\link[=compound]{compound()}} is called
within \code{\link[=collapse.data_request]{collapse()}}, and itself
calls \code{\link[=capture]{capture()}} internally where required.
}
\details{
\code{galah} uses an object-based pipeline to convert piped requests into
valid queries, and to enact those queries with the specified organisation.
Typically, requests open with \code{\link[=galah_call]{galah_call()}} - though \code{\link[=request_metadata]{request_metadata()}}
and \code{\link[=request_files]{request_files()}} are also valid - and end with
\code{\link[=collect.data_request]{collect()}}. Under the hood,
the sequence of functions is as follows:

\code{\link[=capture]{capture()}} → \code{\link[=compound]{compound()}} →
\code{\link[=collapse.data_request]{collapse()}} →
\code{\link[=compute.data_request]{compute()}} →
\code{\link[=collect.data_request]{collect()}}

\code{\link[=compound]{compound()}} is the second of the \code{\link[=galah_call]{galah_call()}} workflow, and it collates
the complete list of queries required to send in order to meet the user's
data request, returned by \code{\link[=collapse.data_request]{collapse()}}.
}
\seealso{
To open a piped query, see \code{\link[=galah_call]{galah_call()}}. For alternative
operations on \verb{_request} objects, see \code{\link[=capture]{capture()}},
\code{\link[=collapse.data_request]{collapse()}},
\code{\link[=compute.data_request]{compute()}} or
\code{\link[=collect.data_request]{collect()}}.
}
