% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/behaviors.R
\name{drag_element_force}
\alias{drag_element_force}
\title{Configure Drag Element Force Behavior}
\usage{
drag_element_force(
  key = "drag-element-force",
  fixed = FALSE,
  enable = NULL,
  state = "selected",
  hideEdge = c("none", "out", "in", "both", "all"),
  cursor = NULL,
  ...
)
}
\arguments{
\item{key}{Unique identifier for the behavior, used for subsequent operations (string, default: "drag-element-force").}

\item{fixed}{Whether to keep the node position fixed after dragging ends (boolean, default: FALSE).}

\item{enable}{Whether to enable the drag function (boolean or JS function, default: JS function that enables dragging for nodes and combos).}

\item{state}{Identifier for the selected state of nodes (string, default: "selected").}

\item{hideEdge}{Controls the display state of edges during dragging: "none", "out", "in", "both", or "all" (string, default: "none").}

\item{cursor}{Customize the mouse style during dragging (list, default: NULL).}

\item{...}{Extra parameters. See \url{https://g6.antv.antgroup.com/en/manual/behavior/drag-element-force}.}
}
\value{
A list with the configuration settings for the drag-element-force behavior.
}
\description{
Creates a configuration object for the drag-element-force behavior in G6.
This allows users to drag nodes and combos with force-directed layout interactions.
}
\examples{
# Basic configuration
config <- drag_element_force()

# Custom configuration with JavaScript arrow function and custom key
config <- drag_element_force(
  key = "my-custom-drag-force",
  fixed = TRUE,
  enable = JS("(event) => { return event.targetType === 'node'; }"),
  hideEdge = "both",
  cursor = list(
    default = "default",
    grab = "grab",
    grabbing = "grabbing"
  )
)
}
