% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X.mat.R
\name{X.mat}
\alias{X.mat}
\title{X.mat (generating a design matrix)}
\usage{
X.mat(n, p, q, r)
}
\arguments{
\item{n}{the number of rows (samples)}

\item{p}{the number of columns (regressors)}

\item{q}{the number of correlated regressors in the first block (1<=q<p, q+r<p)}

\item{r}{the number of correlated regressors in the second block (1<=r<p, q+r<p)}
}
\value{
a matrix X (nrow(X)=n, ncol(X)=p)
}
\description{
A design matrix (X; nrow(X)=n, ncol(X)=p) is generated
 by random numbers as previously used in our simulation studies
 (Section 5 of Yang and Emura (2017); p.6093).
 The design matrix has two blocks of correlated regressors
  (Pearson correlation=0.5): the first q regressors and the second r regressors.
  Other p-q-r regressors are independent.
  If regressors are gene expressions, the correlated blocks may be regarded as
   "gene pathways" (Emura et al. 2012).
}
\examples{
X.mat(n=10,p=5,q=2,r=2)
X.mat(n=100,p=50,q=10,r=10) # Case I in Section 5 of Yang and Emura (2017)
}
\references{
Yang SP, Emura T (2017) A Bayesian approach with generalized ridge estimation
 for high-dimensional regression and testing, Commun Stat-Simul 46(8): 6083-105

Emura T, Chen YH, Chen HY (2012) Survival prediction based on compound covariate method
  under Cox proportional hazard models PLoS ONE 7(10) doi:10.1371/journal.pone.0047627
}
