% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/functional-spectral-density.R
\name{Spec_compare_localize_freq}
\alias{Spec_compare_localize_freq}
\title{Compare the spectral density operator of two Functional Time Series and localize frequencies at which they differ.}
\usage{
Spec_compare_localize_freq(X, Y, B.T = (dim(X)[1])^(-1/5), W, autok = 2,
  subgrid.density, verbose = 0, demean = FALSE, K.fixed = NA,
  subgrid.density.relative.to.bandwidth)
}
\arguments{
\item{X,Y}{The \eqn{T \times nbasis} matrices of containing the coordinates, expressed in some functional basis,  of the two FTS that to be compared.
expressed in a basis.}

\item{B.T}{The bandwidth of frequencies over which the periodogram operator
is smoothed. If \code{B.T=0},  the periodogram operator is returned.}

\item{W}{The weight function used to smooth the periodogram operator. Set by
default to be the Epanechnikov kernel}

\item{autok}{A variable used to specify if (and which) pseudo-AIC criterion
is used to select the truncation parameter \eqn{K}.}

\item{subgrid.density}{Only used if \code{subgrid=TRUE}. Specifies the
approximate number of frequencies within the bandwidth over which the
periodogram operator is smoothed.}

\item{verbose}{A  variable to show the progress of the computations. By
default, \code{verbose=0}.}

\item{demean}{A logical variable to choose if the FTS is centered before
computing its spectral density operator.}

\item{K.fixed}{The value of K used if \code{autok=0}.}

\item{subgrid.density.relative.to.bandwidth}{logical parameter to specify if
\code{subgrid.density} is specified relative to the bandwidth parameter \code{B.T}}
}
\description{
Compare the spectral density operator of two Functional Time Series and localize frequencies at which they differ.
}
\section{Details}{


\code{X,Y} must be of equal size \eqn{T.len \times d}, where T.len is the length of the time series, and \eqn{d} is the number of basis functions. Each row corresponds to a time point, and each column
corresponds to the coefficient of the corresponding basis function of the  FTS.

\code{autok=0} returns the p-values for \eqn{K=1, \ldots, \code{K.fixed}}.
\code{autok=1} uses the \code{AIC} criterion of Tavakoli \& Panaretos
(2015), which is a generalization of the pseudo-AIC introduced in Panaretos
et al (2010).
\code{autok=2} uses the \code{AIC*} criterion of Tavakoli \& Panaretos
(2015), which is an extension of the \code{AIC} criterion that takes into
account the difficulty associated with the estimation of eigenvalues of a
compact operator.
}
\examples{
ma.scale2=ma.scale1=c(-1.4,2.3,-2)
ma.scale2[3] = ma.scale1[3]+.0
a1=Generate_filterMA(10, 10, MA.len=3, ma.scale=ma.scale1)
a2=Generate_filterMA(10, 10, MA.len=3, ma.scale=ma.scale2)
X=Simulate_new_MA(a1, T.len=512, noise.type='wiener')
Y=Simulate_new_MA(a2, T.len=512, noise.type='wiener')
ans0=Spec_compare_localize_freq(X, Y, W=Epanechnikov_kernel, autok=2,
subgrid.density=10, verbose=0, demean=FALSE,
subgrid.density.relative.to.bandwidth=TRUE)
plot(ans0)
plot(ans0, method='fdr')
PvalAdjust(ans0, method='fdr') ## print FDR adjusted p-values
abline(h=.05, lty=3)
ans0=Spec_compare_localize_freq(X, Y, W=Epanechnikov_kernel, autok=0,
subgrid.density=10, verbose=0, demean=FALSE,
subgrid.density.relative.to.bandwidth=TRUE, K.fixed=4) ## fixed values of K
plot(ans0)
plot(ans0, 'fdr')
plot(ans0, 'holm')
PvalAdjust(ans0, method='fdr')
rm(ans0)
}
\references{
\cite{Tavakoli, Shahin and Panaretos, Victor M. "Detecting and Localizing Differences in Functional Time Series Dynamics: A Case Study in Molecular Biophysics", 2014, under revision}

\cite{Panaretos, Victor M., David Kraus, and John H. Maddocks.
"Second-order comparison of Gaussian random functions and the geometry of
DNA minicircles." Journal of the American Statistical Association 105.490
(2010): 670-682.}
}

