% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_mask.R, R/fslhd.R
\name{fsl_mask}
\alias{fsl_mask}
\alias{fslmask}
\title{Mask image using FSL}
\usage{
fsl_mask(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fslmask(
  file,
  mask,
  outfile = NULL,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  opts = "",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{...}{additional arguments passed to \code{\link[neurobase]{readnii}}.}

\item{outfile}{(character) resultant masked image name}

\item{retimg}{(logical) return image of class nifti}

\item{file}{(character) image to be masked}

\item{mask}{(character) mask given for image}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link[neurobase]{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{opts}{(character) additional options to be passed to fslmask}

\item{verbose}{(logical) print out command before running}
}
\value{
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslmaths -mas} to mask an image from 
an image mask and either saves the image or returns an object of class nifti
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e5), dim = c(100, 100, 10))
img = nifti(x, dim= c(100, 100, 10), 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
mask = img > .5
masked = fslmask(img, mask = mask, retimg=TRUE)
})
} 
}
