% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ET_Penman.R
\name{ET_penman}
\alias{ET_penman}
\title{Calculation of daily potential evapotranspiration by Penman (1948) method}
\usage{
ET_penman(climdata, lat, elev)
}
\arguments{
\item{climdata}{a dataframe with daily weather data.
Must contain the columns Year, Month, Day, Tmax, Tmin, RHmax, RHmin, Rad, u2med.}

\item{lat}{the latitude of the site, in decimal degrees.}

\item{elev}{the elevation of the site, in meters above sea level.}
}
\value{
dataframe where Date, DOY and ET columns have been added to the ones
in climadata data frame.
}
\description{
This function calculates the potential evapotranspiration (ETref) using daily 
weather data and the Penman (1948) method
}
\details{
This version of the function requires the user to supply in weather data daily
values for temperature (Tmax and Tmin), relative humidity (RHmax and RHmin), 
solar radiation (Rad in MJ m-2 day-1) and mean wind speed at 2m height 
(u2med in m s-1).
}
\examples{
 # Calculate ET by Penman method in the Tudela_DW example dataset
data(Tudela_DW)
library(magrittr)
library(dplyr)
elevation <- 314
latitude <- 42.13132
ET_Penman <- ET_penman(Tudela_DW, elevation, latitude) 

}
\references{
Penman HL 1948.Natural evaporation from open water, bare soil and grass.
Proc. R. Soc. Lond. 193:120–145.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
