% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nisurface.R
\name{read_nisurfacefile}
\alias{read_nisurfacefile}
\title{S3 method to read a neuroimaging surface file.}
\usage{
read_nisurfacefile(filepath, methods = c("fsnative", "fsascii", "gifti"), ...)
}
\arguments{
\item{filepath}{character string, the full path to the input surface file.}

\item{methods}{list of character strings, the formats to try. Each of these must have a function called \code{read_nisurface.<method>}, which must return an `fs.surface` instance on success.}

\item{...}{parameters passed on to the individual methods}
}
\value{
an instance of `fs.surface`, read from the file. See \code{\link[freesurferformats]{read.fs.surface}} for details. If none of the reader methods succeed, an error is raised.
}
\description{
Tries to read the file with all implemented surface format reader methods. The file must exist. With the default settings, one can read files in the following surface formats: 1) FreeSurfer binary surface format (e.g., `surf/lh.white`). 2) FreeSurfer ASCII surface format (e.g., `surf/lh.white,asc`). 3) GIFTI surface format, only if package `gifti` is installed. See \code{gifti::read_gifti} for details. Feel free to implement additional methods. Hint:keep in mind that they should return one-based indices.
}
\examples{
    surface_file = system.file("extdata", "lh.tinysurface",
                            package = "freesurferformats", mustWork = TRUE);
    mesh = read_nisurface(surface_file);
    mesh;

}
\seealso{
Other mesh functions: 
\code{\link{faces.quad.to.tris}()},
\code{\link{read.fs.surface}()},
\code{\link{read.fs.surface.asc}()},
\code{\link{read.fs.surface.bvsrf}()},
\code{\link{read.fs.surface.geo}()},
\code{\link{read.fs.surface.gii}()},
\code{\link{read.fs.surface.ico}()},
\code{\link{read.fs.surface.obj}()},
\code{\link{read.fs.surface.off}()},
\code{\link{read.fs.surface.ply}()},
\code{\link{read.fs.surface.vtk}()},
\code{\link{read.mesh.brainvoyager}()},
\code{\link{read_nisurface}()},
\code{\link{write.fs.surface}()},
\code{\link{write.fs.surface.asc}()},
\code{\link{write.fs.surface.byu}()},
\code{\link{write.fs.surface.gii}()},
\code{\link{write.fs.surface.mz3}()},
\code{\link{write.fs.surface.vtk}()}
}
\concept{mesh functions}
