% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frbinom.R
\name{dfrbinom}
\alias{dfrbinom}
\alias{pfrbinom}
\alias{qfrbinom}
\alias{rfrbinom}
\title{Fractional binomial distributions}
\usage{
dfrbinom(x, size, prob, h, c, start = FALSE)

pfrbinom(x, size, prob, h, c, start = FALSE)

qfrbinom(p, size, prob, h, c, start = FALSE)

rfrbinom(n, size, prob, h, c, start = FALSE)
}
\arguments{
\item{x}{A numeric vector specifying values of the fractional binomial random variable at which the pmf or cdf is computed.}

\item{size}{A number specifying the total number of trials.}

\item{prob}{A number specifying the probability of success in each trial.}

\item{h}{A number specifying the strength of the dependency among trials; it determines  the skewness of the distribution.}

\item{c}{A number specifying the overdispersion of distributions.}

\item{start}{logical; if TRUE, the starting point is changed after the first success in the generalized Bernoulli process. The default is FALSE.}

\item{p}{A numeric vector specifying probabilities at which quantiles of the fractional binomial distribution are computed.}

\item{n}{A number of random variables to be simulated.}
}
\value{
A numeric vector of random variables (rfrbinom) or pmf (dfrbinom) or cdf (pfrbinom) or quantile (qfrbinom) of the fractional binomial distribution.
}
\description{
Generating random variables and computing density, cumulative distribution, and quantiles of the fractional binomial distribution with the parameters \code{size}, \code{prob},  \code{h}, \code{c}.
}
\details{
The regular binomial random variable counts the number of successes in i.i.d. Bernoulli trials.
In the fractional binomial distribution,  the number of successes is counted among  dependent Bernoulli trials that are from the generalized Bernoulli process (GBP).
In GBP, each trial has the constant probability of success \code{prob}, and the strength of the dependency among the trials is determined by the parameters, \code{h} and \code{c}.  The parameters \code{c} and \code{h} are related to the overdispersion and skewness of the fractional binomial distribution.
The parameters \code{prob}=\eqn{p}, \code{h}=\eqn{H}, \code{c}=\eqn{c} should satisfy
\eqn{p,H \in (0,1)} and
\deqn{0\leq c<\min\{1-p, \frac{1}{2} ( -2p+2^{2H-2} +\sqrt{4p-p2^{2H}+2^{4H-4}})\}.}
With the number of trials (\code{size}) =\eqn{n}, the mean of the fractional binomial random variable is \eqn{E(X)=np},
and the variance is asymptotically proportional to \eqn{n^{2H}}, if \eqn{H\in (0.5, 1)};
\eqn{n\ln n}, if \eqn{H=0.5}; and \eqn{n}, if \eqn{H\in (0, .5)}.
If \code{c}=0, it becomes the regular binomial distribution.
}
\section{Functions}{
\itemize{
\item \code{dfrbinom()}: The pmf of fractional binomial distribution.

\item \code{pfrbinom()}: The cdf of fractional binomial distribution.

\item \code{qfrbinom()}: The quantiles  of fractional binomial distribution.

\item \code{rfrbinom()}: The generation of fractional binomial random variables.

}}
\examples{
# 10 random variables of a fractional binomial distribution.
rfrbinom(n=10, size=50, prob=.6, h=.8, c=.2)
# The probability that the fractional binomial random variable equals 22.
dfrbinom(x=22, size=50, prob=.6, h=.8, c=.2)
# The probability that the fractional binomial random variable is less than or equal to 22.
pfrbinom(x=22, size=50, prob=.6, h=.8, c=.2)
 # The 80th percentile of the fractional binomial distribution.
qfrbinom(p=.8, size=50, prob=.6, h=.8, c=.2)

}
\references{
Lee, J. (2021). Generalized Bernoulli process with long-range dependence and fractional binomial distribution. Dependence Modeling, 9(1), 1-12.
}
