% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stubs.R
\name{stubs_publish}
\alias{stubs_publish}
\title{Publish Stub Templates for Customization}
\usage{
stubs_publish(type = "all", overwrite = FALSE, stubs = NULL)
}
\arguments{
\item{type}{Character vector. Which stub types to publish:
\itemize{
\item "notebooks" - Quarto/RMarkdown notebook stubs
\item "scripts" - R script stubs
\item "all" - All stubs (default)
}}

\item{overwrite}{Logical. Whether to overwrite existing stubs. Default FALSE.}

\item{stubs}{Character vector. Specific stub names to publish (e.g., "default", "minimal").
If NULL (default), publishes all stubs of the specified type.}
}
\value{
Invisible list of published file paths
}
\description{
Copies framework stub templates to your project's \verb{stubs/} directory, allowing
you to customize them. Similar to Laravel's \verb{artisan vendor:publish} command.
}
\details{
\subsection{Stub Customization Workflow}{
\enumerate{
\item Publish stubs to your project: \code{stubs_publish()}
\item Edit stubs in \verb{stubs/} directory to match your preferences
\item Use \code{make_notebook()} or \code{make_script()} - your custom stubs are used automatically
}
}

\subsection{Stub Naming Convention}{

Stubs follow this naming pattern:
\itemize{
\item Notebooks: \verb{stubs/notebook-\{name\}.qmd} or \verb{stubs/notebook-\{name\}.Rmd}
\item Scripts: \verb{stubs/script-\{name\}.R}
}

Framework searches user stubs first, then falls back to built-in stubs.
}

\subsection{Available Placeholders}{

Stubs can use these placeholders:
\itemize{
\item \code{{filename}} - File name without extension
\item \code{{date}} - Current date (YYYY-MM-DD)
}
}
}
\examples{
\donttest{
if (FALSE) {
# Publish all stubs
stubs_publish()

# Publish only notebook stubs
stubs_publish("notebooks")

# Publish specific stub
stubs_publish(stubs = "default")

# Overwrite existing stubs
stubs_publish(overwrite = TRUE)
}
}

}
\seealso{
\code{\link[=make_notebook]{make_notebook()}}, \code{\link[=make_script]{make_script()}}, \code{\link[=stubs_list]{stubs_list()}}, \code{\link[=stubs_path]{stubs_path()}}
}
