% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibtex.R
\name{format_bibtex_entry}
\alias{format_bibtex_entry}
\alias{format_bibtex_file}
\title{Format BibTeX Entries in An Opinionated Way}
\usage{
format_bibtex_entry(
  entry,
  fields = c("title", "author", "journal", "pages"),
  protected_words = NULL,
  ...
)

format_bibtex_file(
  bibtex_file,
  output_file = bibtex_file,
  backup = (output_file == bibtex_file),
  dry_run = FALSE,
  ...
)
}
\arguments{
\item{entry}{A \code{bibentry} object (created by \code{utils::bibentry})
representing BibTeX entries.}

\item{fields}{A character vector specifying the fields to format.  The
available options are \code{"title"}, \code{"author"}, \code{"journal"},
and \code{"pages"}.  Multiple choices can be specified.}

\item{protected_words}{Optional words that needs protection by curly braces
from cases changing by BibTeX style.}

\item{...}{Other arguments passed to \code{format_bibtex_entry}.}

\item{bibtex_file}{A character string presenting the BibTeX file that needs
formatting.}

\item{output_file}{A character string presenting the output BibTeX file.  By
default, the input BibTeX file will be overwritten with a backup file.}

\item{backup}{A logical value.  If \code{TRUE}, a backup file will be
created to check and tweak the formatting options.}

\item{dry_run}{A logical value.  If \code{TRUE}, the formatted BibTeX
entries will be returned without actually (over)writing a BibTeX file to
the disk.  The default value is \code{FALSE}.}
}
\value{
A \code{bibtex} object.
}
\description{
This function tries to format the given BibTeX entries so that
\itemize{

\item The \dQuote{title} field is written in the title case with
   exceptations such as common prepositions with four or fewer letters.
   Special words such as \dQuote{Bayesian} and \dQuote{Markov} are protected
   by curly braces from case changing by BibTeX sytle.

\item The \dQuote{author} field follows a consistent fashion: \dQuote{family
   name, given name}.  A period will be added to single letter acronym.

\item The \dQuote{journal} field (if any) is written in the title case.

\item The \dQuote{pages} field should use \dQuote{--} instead of \dQuote{-}
  between pages.

}
}
\details{
When \code{emacs} is available in the system, the function
\code{format_bibtex_file()} will perform additional formatting with the help
of the commands \code{bibtex-reformat} and \code{bibtex-sort-buffer}.
}
\examples{
library(formatBibtex)

## example BibTeX file that needs formatting
example_bib <- system.file("examples/example.bib", package = "formatBibtex")
print(readLines(example_bib), quote = FALSE)

## check the default words that need protection by curly braces
format_options$get("protected_words")
## append "SMEM" to the list
format_options$append("protected_words", c("SMEM"))

## needs the package bibtex
if (requireNamespace("bibtex", quietly = TRUE)) {
    ## example of format_bibtex_entry()
    bib <- bibtex::read.bib(example_bib)
    format_bibtex_entry(bib)
    ## example of format_bibtex_file()
    output_file <- tempfile(fileext = ".bib")
    format_bibtex_file(example_bib, output_file = output_file)
    print(readLines(output_file), quote = FALSE)
}
}
