% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foodweb.R
\name{spanTag}
\alias{spanTag}
\title{spanTag}
\usage{
spanTag(v, direction = "COLSPAN", colorMap)
}
\arguments{
\item{v}{character vector representing first row of m (excluding first 2 entries of m)}

\item{direction}{character string COLSPAN or ROWSPAN}

\item{colorMap}{character array of colors}
}
\value{
returns a list whose components are
\itemize{
\item u return value of unique(v)
\item tab return value of table(v)
\item v2 character vector modified version of v containing html span tags
}
}
\description{
Add html tag for package name to span multiple columns.
Also insert hyperlink to CRAN package and function documentation.
}
\details{
see https://www.pierobon.org/html/span.htm#:~:text=Cells\%20within\%20HTML\%20tables\%20can,span\%20more\%20than\%20one\%20column.
}
\examples{
if(interactive()){
load("data/x_m5.RData")
load("data/x_colorMap.RData")
l<-spanTag(x_m5[1,c(-1,-2)],"COLSPAN",x_colorMap)
}

}
