% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pricing.R
\name{fmpc_price_batch_eod}
\alias{fmpc_price_batch_eod}
\title{Pull all EOD pricing data for a specific date}
\usage{
fmpc_price_batch_eod(priceDate = Sys.Date() - 1)
}
\arguments{
\item{priceDate}{price date to pull all securities. Use format yyyy-mm-dd}
}
\value{
data frame of a single days prices
}
\description{
Returns 10,000 or more symbols for a specific date. This generates one API
call for each date. Dates must be entered one at a time.
}
\examples{
\dontrun{

fmpc_set_token('FMPAPIKEY')
allSymbs = fmpc_price_batch_eod('2020-06-24')

}
}
