% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{fmpc_cots_data}
\alias{fmpc_cots_data}
\title{Get COTS data}
\usage{
fmpc_cots_data(
  cots_sym = "all",
  startDate = Sys.Date() - 30,
  endDate = Sys.Date()
)
}
\arguments{
\item{cots_sym}{COTS symbol that can be found in
\code{\link{fmpc_cots_symbols}}. Default is 'all'. Date parameters are only
valid with 'all'. Otherwise the full history is pulled.}

\item{startDate}{filter start date in yyyy-mm-dd format.}

\item{endDate}{filter end date in yyyy-mm-dd format.}
}
\value{
a data frame of cots data
}
\description{
Provides raw data from Commitment of Traders report
}
\examples{

\dontrun{

# Must set a valid API token
fmpc_set_token('FMPAPIKEY')
fmpc_cots_data()

}
}
